--
-- Parameters
--

DECLARE @Graph	NVARCHAR(MAX)	= '
SELECT ''A'' AS Node1, ''B'' AS Node2, 2 AS Cost
UNION
SELECT ''A'' AS Node1, ''C'' AS Node2, 6 AS Cost
UNION
SELECT ''B'' AS Node1, ''D'' AS Node2, 5 AS Cost
UNION
SELECT ''C'' AS Node1, ''D'' AS Node2, 8 AS Cost
UNION
SELECT ''C'' AS Node1, ''E'' AS Node2, 2 AS Cost
UNION
SELECT ''D'' AS Node1, ''F'' AS Node2, 10 AS Cost
UNION
SELECT ''D'' AS Node1, ''G'' AS Node2, 15 AS Cost
UNION
SELECT ''G'' AS Node1, ''F'' AS Node2, 6 AS Cost
UNION
SELECT ''G'' AS Node1, ''H'' AS Node2, 6 AS Cost
UNION
SELECT ''F'' AS Node1, ''H'' AS Node2, 2 AS Cost
UNION
SELECT ''E'' AS Node1, ''F'' AS Node2, 20 AS Cost
'									
DECLARE @Source	VARCHAR(128) = 'A'	-- You may put any node here for @Source		
DECLARE @Target	VARCHAR(128) = 'H'	-- You may put any node here for @Target	

-- Declarations
DECLARE @ROW_COUNT	INT
DECLARE @Cost		VARCHAR(16)
DECLARE @Path		VARCHAR(MAX)
DECLARE @Node		VARCHAR(128)

--  Drop table #Graph
IF OBJECT_ID(N'tempdb..#Graph') IS NOT NULL DROP TABLE #Graph

--  Create table #Graph
CREATE TABLE #Graph (
Node1	VARCHAR(128)
,Node2	VARCHAR(128)
,Cost	INT 
);

-- Populate table #Graph
INSERT INTO #Graph EXEC dbo.sp_executeSQL @Graph

-- Drop table #RED
IF OBJECT_ID(N'tempdb..#RED') IS NOT NULL DROP TABLE #RED

--  Create table #RED
CREATE TABLE #RED (
[Node]		VARCHAR(128)
,[Next]	VARCHAR(128)
,Cost		INT 
);

-- Initialize table #RED with @Source
INSERT INTO #RED SELECT @Source AS [Node], @Source AS [Next], 0 AS Cost 

-- Populate table #RED according to induction argument
SET @ROW_COUNT = -1
WHILE @ROW_COUNT <> 0
BEGIN
	INSERT INTO #RED
	SELECT TOP 1 d.[Node], d.[Next], d.Cost FROM	-- Select top row from query
	(
	SELECT Graph.Node2 AS [Node], RED.[Node] AS [Next], Graph.Cost + RED.Cost AS Cost 
	FROM #Graph Graph INNER JOIN #RED RED ON Graph.Node1 = RED.[Node]
	WHERE Graph.Node2 NOT IN (SELECT [Node] FROM #RED)

	UNION -- Required since edges have no direction

	SELECT Graph.Node1 AS [Node], RED.[Node] AS [Next], Graph.Cost + RED.Cost AS Cost 
	FROM #Graph Graph INNER JOIN #RED RED ON Graph.Node2 = RED.[Node]
	WHERE Graph.Node1 NOT IN (SELECT [Node] FROM #RED)
	) d
	ORDER BY d.Cost ASC	-- Pick closest neighbor to @Source
	SET @ROW_COUNT = @@ROWCOUNT
END

--
-- Display answer 
--

-- Get cost of minimal path from @Target to @Source
SELECT @Cost = Cost FROM #RED WHERE [Node] = @Target  -- @Target may not belong to #RED 

IF @Cost IS NOT NULL  -- @Target belongs to #RED  
	BEGIN
	-- Build minimal path from @Source to @Target 
	SET @Path = @Target
	SET @Node = @Target
	WHILE @Node <> @Source -- Loop through nodes from @Target to @Source using Next column in #RED
		BEGIN
		SELECT @Node = [Next] FROM #RED WHERE [Node] = @Node	-- Get Next node for current node
		SET @Path = @Node + ' --> ' + @Path			-- Append to path
		END

	-- Display minimal path from @Source to @Target
	SELECT @Cost AS Cost, @Path AS Path

	-- Display all minimal paths
	SELECT * FROM #RED
	END
ELSE
	SELECT -1 AS Cost, '@Source and @Path are not connected' AS Path
